uniform vec2 center; 
uniform vec2 resolution;
uniform float time;
uniform vec2 mouse; 
uniform float pulse1;
uniform float pulse2;
uniform float pulse3; 



vec4 DrawSun(vec2 uv, float speed)
{
    float dist = distance(uv, vec2(0.0));
    float circle = step(dist, 0.5);   
    
    float lines =sin(uv.y * 50.0 + time * speed) * ((1.0 - uv.y) * 0.5);
    lines *= 1.0;
    lines = step(lines, 0.5);
    
    circle *= lines;
    
    vec3 yellow = vec3(0.921, 0.843, 0);
    vec3 pink = vec3(0.941, 0, 0.737);
	
    float gradientMask = ((1.0 - uv.y) * 0.5);
    gradientMask += 0.1;
    gradientMask *= gradientMask;
   	vec3 gradient = mix(yellow, pink, gradientMask);
    
    vec3 sun = circle * gradient;
    
    dist = 1.0 - dist;
    dist = clamp(dist, 0.0, 0.5);
    
    dist *= (sin(time * 2.0) + 10.0) * 0.11;
    
 
    gradient *= dist;
    sun = mix(sun, gradient, dist);
    return vec4(sun, 1.0);
}


vec4 DrawGrid(vec2 uv)
{   
    float isVisible = step(uv.y, -0.1);
    float gradientMask = ((0.85 - uv.y) * 1.0);
    
    uv.y = 2.0 / uv.y;
    uv.x *= uv.y;
    
    vec2 grid = fract(uv - vec2(0.0, time * 5.0)) * 0.05 * (1.0 - uv.y) / fwidth(uv);
    float line = min(grid.x, grid.y);
    line = clamp(line, 0.0, 1.0);
    line = 1.0 - line;
    
    vec3 blue = vec3(0, 0.047, 0.239);
    vec3 pink = vec3(0.941, 0, 0.737);
	
    gradientMask *= gradientMask;
    gradientMask = clamp(gradientMask, 0.0, 1.0);
    gradientMask -= isVisible;
   	vec3 gradient = gradientMask * pink;

    vec3 bg = (isVisible - (isVisible * line * 1.8)) * blue;
    
    return vec4((clamp(isVisible * line, 0.0, 1.0) * pink) + gradient + bg, gradientMask + isVisible);
    
}

void main(){
    vec2 uv = (2.0 * gl_FragCoord - resolution.xy) / resolution.y;

    vec4 sun = DrawSun(uv + vec2(0.0, -0.35), 20.0);
    vec4 grid = DrawGrid(uv + vec2(0.0, 0.15));
    

	gl_FragColor = sun;
    gl_FragColor = mix(gl_FragColor, grid, grid.a); 
}